--The scripts should always contain at least 10 functions :ScriptID, DisplaySourceName(), SourceSuperClassID(), SourceClassID(), DisplayDestinationName() DestinationSuperClassID(), DestinationClassID(), AboutText() and DefaultConversion, Conversion taking a param.
--Script ID that will append to destination
fn ScriptID = 
(
	""
)

--Return the name to be display for the source in the Scene Converter UI
fn DisplaySourceName =
(
	"Autodesk Bitmap"
)

--Returns the source class of the super class id 
fn SourceSuperClassID =
(
	3088 --Texture
)
--Returns the class id of the source class we use as a source for conversion
fn SourceClassID =
(
	#(0x7ed417e4L, 0x273deef8L) --Autodesk Bitmap
)

--Return the name to be display for the destination in the Scene Converter UI
fn DisplayDestinationName =
(
	"Bitmap Texture"
)

--Returns the destination class of the super class id
fn DestinationSuperClassID =
(
	3088 --Texture
)
--Returns the class id of the class we use as a destination for conversion
-- so we convert from SourceClassID() to DestinationClassID()
fn DestinationClassID =
(
	#(0x240L, 0x0L) --Bitmap Texture
)

--Validate that the source provided match with one of the SourceClass
fn VerifySource source =
(
	local ret = false	
	local src = SourceClassID()
	
	if(source == undefined) do return false
	
	if(classof src[1] == Array) then
    (
		for cd in src do
		(
			if((cd as string) == (source.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((src as string) == (source.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)
--Validate that the destination provided match with one of the DestinationClass
fn VerifyDestination destination =
(
	local ret = false	
	local dest = DestinationClassID()

	if(destination == undefined) do return false
	
	if(classof dest[1] == Array) then
    (
		for cd in dest do
		(
			if((cd as string) == (destination.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((dest as string) == (destination.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)

--Returns some information about this conversion script
--Should this be localized ?
fn AboutText =
(
	"Converts from an Autodesk Bitmap to a Bitmap Texture"
)


--Internal function that does the parameter mapping
fn ConvertFrom_AutodeskBitmapToBitmapTexture Source Dest =
(
	if ( false == VerifySource Source or 
		 false == VerifyDestination Dest
		) do
	(
		--Not the suitable nodes
		return undefined
	)
	
	
	if (IsProperty Source "Parameters_Source") and (undefined != Source.Parameters_Source) do
	(
		Dest.bitmap = Source.Parameters_Source
	)
	

	if (IsProperty Source "Parameters_Brightness") and (undefined != Source.Parameters_Brightness) do
	(
		Dest.output.RGB_Level = Source.Parameters_Brightness / 100
	)

	if (IsProperty Source "Parameters_Invert_Image") and (undefined != Source.Parameters_Invert_Image) do
	(
		Dest.output.invert = Source.Parameters_Invert_Image
	)
	
	Dest.coords.mappingType = 0 --Texture
	Dest.coords.mapping = 0 --Explicit Map Channel
	Dest.coords.realWorldScale = true
	
	if (IsProperty Source "Position_X") and (undefined != Source.Position_X) do
	(
		Dest.coords.U_Offset = Source.Position_X
		if(Source.Position_X.controller != undefined) do Dest.coords.U_Offset.controller = Source.Position_X.controller
	)

	if (IsProperty Source "Position_Y") and (undefined != Source.Position_Y) do
	(
		Dest.coords.V_Offset = Source.Position_Y
		if(Source.Position_Y.controller != undefined) do Dest.coords.V_Offset.controller = Source.Position_Y.controller
	)

	if (IsProperty Source "Scale_Width") and (undefined != Source.Scale_Width) do
	(
		Dest.coords.realWorldWidth = Source.Scale_Width
		if(Source.Scale_Width.controller != undefined) do Dest.coords.realWorldWidth.controller = Source.Scale_Width.controller
	)

	if (IsProperty Source "Scale_Height") and (undefined != Source.Scale_Height) do
	(
		Dest.coords.realWorldHeight = Source.Scale_Height
		if(Source.Scale_Height.controller != undefined) do Dest.coords.realWorldHeight.controller = Source.Scale_Height.controller
	)

	--According to the documentation the rotation is done on the Z axis, so rotation is on the W axis
	if (IsProperty Source "Position_Rotation") and (undefined != Source.Position_Rotation) do
	(
		Dest.coords.W_Angle = Source.Position_Rotation
		if(Source.Position_Rotation.controller != undefined) do Dest.coords.W_Angle.controller = Source.Position_Rotation.controller
	)
	Dest.coords.V_Angle = 0.0
	Dest.coords.U_Angle = 0.0	
	
	Dest.coords.U_Mirror = false
	Dest.coords.V_Mirror = false
	if (IsProperty Source "Repeat_Horizontal") and (undefined != Source.Repeat_Horizontal) do
	(
		Dest.coords.U_Tile = Source.Repeat_Horizontal
	)
	if (IsProperty Source "Repeat_Vertical") and (undefined != Source.Repeat_Vertical) do
	(
		Dest.coords.V_Tile = Source.Repeat_Vertical
	)
	
	if (IsProperty Source "Advanced_Parameters_Blur") and (undefined != Source.Advanced_Parameters_Blur) do
	(
		Dest.coords.Blur = Source.Advanced_Parameters_Blur
		if(Source.Advanced_Parameters_Blur.controller != undefined) do Dest.coords.Blur.controller = Source.Advanced_Parameters_Blur.controller
	)

	if (IsProperty Source "Advanced_Parameters_Blur_Offset") and (undefined != Source.Advanced_Parameters_Blur_Offset) do
	(
		Dest.coords.Blur_Offset = Source.Advanced_Parameters_Blur_Offset
		if(Source.Advanced_Parameters_Blur_Offset.controller != undefined) do Dest.coords.Blur_Offset.controller = Source.Advanced_Parameters_Blur_Offset.controller
	)

	if (IsProperty Source "Advanced_Parameters_Filtering") and (undefined != Source.Advanced_Parameters_Filtering) do
	(
		Dest.filtering = Source.Advanced_Parameters_Filtering
	)
	if (IsProperty Source "Advanced_Parameters_Map_Channel") and (undefined != Source.Advanced_Parameters_Map_Channel) do
	(
		Dest.coords.mapChannel = Source.Advanced_Parameters_Map_Channel
	)
)

--This function is use as entry when the source is missing (due to a missing plugin) and cannot be completly loaded. 
--In that case the default parameters are loaded.
fn DefaultConversion source /*not use*/ =
(
	newTexture = BitmapTexture()
	
	--return the new texture
	newTexture
)

--Main entry point from this script
--This function handles the texture's creation
fn Conversion autodeskBitmap =
(
	if (false == VerifySource autodeskBitmap )  do
	(
		--Not the suitable node
		return undefined
	)	
	
	newTexture = BitmapTexture()
	
	--Call the parameters mapping function to convert
	ConvertFrom_AutodeskBitmapToBitmapTexture autodeskBitmap newTexture
	
	if (IsProperty autodeskBitmap "name") and (undefined != autodeskBitmap.name) and (String == classof autodeskBitmap.name)  and (IsProperty newTexture "name") do
	(
		newTexture.name = autodeskBitmap.name
	)
	
	--return the new texture
	newTexture
)